package gov.va.med.mhv.sm.admin.enums;

import java.io.Serializable;

public enum WorkloadCaptureTypeEnum implements Serializable{

	WORKLOAD_CREDIT (1L, "Workload Credit"), // A represents All records Send to PCE
	HISTORICAL_NOTE (2L, "Historical"); // N represents Send No records to PCE. 

	private Long id;
	private String description;
	
	private WorkloadCaptureTypeEnum(Long id, String description){
		this.id = id;
		this.description = description;
	}
	public Long getId() {
		return id;
	}
	public void setId(Long id) {
		this.id = id;
	}
	public String getDescription() {
		return description;
	}
	public void setDescription(String description) {
		this.description = description;
	}
	
	public static WorkloadCaptureTypeEnum valueOf(Long value){
		for(WorkloadCaptureTypeEnum f : WorkloadCaptureTypeEnum.values()){
			if(f.getId().equals(value))
				return f;
		}
		/* none found; throw error */
		throw new RuntimeException("no workload user type found");
	}
}
